/*
 * @(#)SolutionPane.java  1.0  14. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm;

import java.awt.*;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * SolutionPane.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 14. M�rz 2006 Created.
 */
public class SolutionPane extends javax.swing.JPanel {

    protected ResourceBundleUtil labels;

    /** Creates new form. */
    public SolutionPane() {
        labels = ResourceBundleUtil.getBundle("ch.hslu.cm.Labels");
        initComponents();
        view.putClientProperty("css.class", "solution");
        putClientProperty("css.class", "solutionPane");
        setOpaque(true);
        // buttonPanel.setOpaque(false);
        // setBackground(new Color(UIManager.getColor("Panel.background").getRGB() & 0x80ffffff,true));
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(getBackground());
        g.fillRect(0, 0, getWidth(), getHeight());
        super.paint(g);
    }

    public void setDrawing(Drawing d) {
        view.setDrawing(d);
    }

    public void close() {
        Container parent = getParent();
        if (parent != null) {
            parent.remove(this);
            parent.repaint();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttonPanel = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();
        scrollPane = new javax.swing.JScrollPane();
        view = new org.jhotdraw.draw.DefaultDrawingView();

        setLayout(new java.awt.BorderLayout());

        setBorder(javax.swing.BorderFactory.createTitledBorder(labels.getString("solution")));
        buttonPanel.setOpaque(false);
        closeButton.setText(labels.getString("close"));
        closeButton.setOpaque(false);
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                close(evt);
            }
        });

        buttonPanel.add(closeButton);

        add(buttonPanel, java.awt.BorderLayout.SOUTH);

        scrollPane.setViewportView(view);

        add(scrollPane, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

    private void close(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_close
        close();
    }//GEN-LAST:event_close
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton closeButton;
    private javax.swing.JScrollPane scrollPane;
    private org.jhotdraw.draw.DefaultDrawingView view;
    // End of variables declaration//GEN-END:variables
}
